"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.storeChatboatListingModel = exports.chatBoatListingCityWise = exports.chatboatListingModel = exports.chatboatListingDetails = exports.chatboatUserListModel = void 0;
const chatboatUser_schema_1 = __importDefault(require("../schema/chatboatUser.schema"));
const listing_schema_1 = __importDefault(require("../schema/listing.schema"));
const chatboat_schema_1 = __importDefault(require("../schema/chatboat.schema"));
const mongoose_1 = __importDefault(require("mongoose"));
const chatboatUserListModel = (search, page, limit) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b, _c, _d;
    try {
        const skip = (page - 1) * limit;
        const result = yield chatboatUser_schema_1.default.aggregate([
            {
                $lookup: {
                    from: "categories",
                    localField: "category_ids",
                    foreignField: "unique_id",
                    as: "category_ids"
                }
            },
            {
                $match: {
                    $or: [
                        { "category_ids.name": { $regex: search || "", $options: "i" } },
                        { phone_number: { $regex: search || "", $options: "i" } },
                        { city_name: { $regex: search || "", $options: "i" } }
                    ]
                }
            },
            {
                $project: {
                    "category_ids.name": 1,
                    city_name: 1,
                    phone_number: 1,
                    createdAt: 1
                }
            },
            {
                $facet: {
                    totalCount: [{ $count: "count" }],
                    data: [{ $skip: skip }, { $limit: limit }, { $sort: { createdAt: -1 } }]
                }
            }
        ]);
        return {
            data: result[0].data,
            totalUsers: ((_b = (_a = result[0]) === null || _a === void 0 ? void 0 : _a.totalCount[0]) === null || _b === void 0 ? void 0 : _b.count) || 0,
            totalPages: Math.ceil(((_d = (_c = result[0]) === null || _c === void 0 ? void 0 : _c.totalCount[0]) === null || _d === void 0 ? void 0 : _d.count) / limit) || 0,
            currentPage: page
        };
    }
    catch (error) {
        console.log(error);
    }
});
exports.chatboatUserListModel = chatboatUserListModel;
const chatboatListingDetails = (chatboat_id, callback) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        // Fetch ChatboatListing as plain object
        const chatboat_listing = yield chatboat_schema_1.default.findOne({ _id: chatboat_id }).lean();
        if (!chatboat_listing) {
            return callback(new Error("Chatboat listing not found"), null);
        }
        // Handle city_id enrichment (assuming it's a single number, not array)
        const cityId = chatboat_listing.city_id;
        let enrichedCity = null;
        if (typeof cityId !== "undefined" && cityId !== null) {
            enrichedCity = yield mongoose_1.default.connection.collection("cities").findOne({ unique_id: cityId }, {
                projection: { _id: 1, unique_id: 1, name: 1 }
            });
        }
        // Fetch listings by listing_unique_id
        const listingIds = Array.isArray(chatboat_listing.listing_id)
            ? chatboat_listing.listing_id
            : [];
        const listingsFromSchema = yield listing_schema_1.default.aggregate([
            {
                $match: {
                    listing_unique_id: { $in: listingIds }
                }
            },
            {
                $lookup: {
                    from: "cities",
                    localField: "city_id", // array or number of city unique_ids
                    foreignField: "unique_id",
                    as: "city_info"
                }
            },
            {
                $addFields: {
                    city_id: {
                        $map: {
                            input: "$city_info",
                            as: "city",
                            in: {
                                _id: "$$city._id",
                                unique_id: "$$city.unique_id",
                                name: "$$city.name"
                            }
                        }
                    }
                }
            },
            {
                $project: {
                    city_info: 0
                }
            }
        ]);
        const chatboat_listing_response = Object.assign(Object.assign({}, chatboat_listing), { city_id: enrichedCity, listing_id: listingsFromSchema });
        return callback(null, { chatboat_listing: chatboat_listing_response });
    }
    catch (error) {
        console.error("Error in chatboatListingDetails:", error);
        return callback(error, null);
    }
});
exports.chatboatListingDetails = chatboatListingDetails;
const chatboatListingModel = (search, page, limit) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b, _c, _d, _e;
    try {
        const skip = (page - 1) * limit;
        const pipeline = [
            // Stage 1: Lookup Listings
            // Keep this as 'listing_info_array' if 'listing_id' can be an array in ChatboatListing
            {
                $lookup: {
                    from: "listings",
                    localField: "listing_id",
                    foreignField: "listing_unique_id",
                    as: "listing_info_array"
                }
            },
            // Stage 2: Lookup Cities
            // Keep this as 'city_info_array' if 'city_id' can be an array in ChatboatListing
            {
                $lookup: {
                    from: "cities",
                    localField: "city_id",
                    foreignField: "unique_id",
                    as: "city_info_array"
                }
            },
            // Stage 3: Apply initial Match condition before unwinding extensively
            // This is to filter down documents early if possible, though the core match
            // with unwound data will happen later if necessary.
            // This match relies on dot notation for array fields.
            {
                $match: {
                    $or: [
                        // Match if any listing name in the array matches
                        { "listing_info_array.name": { $regex: search || "", $options: "i" } },
                        // Match if any city name in the array matches
                        { "city_info_array.name": { $regex: search || "", $options: "i" } }
                    ]
                }
            },
            // Stage 4: Deconstruct listing_info_array for later access
            // We only unwind if it's not null/empty to avoid unnecessary documents
            // for records without listings.
            {
                $unwind: {
                    path: "$listing_info_array",
                    preserveNullAndEmptyArrays: true
                }
            },
            // Stage 5: Deconstruct city_info_array for later access
            {
                $unwind: {
                    path: "$city_info_array",
                    preserveNullAndEmptyArrays: true
                }
            },
            // Stage 6: Group back to collect all matched names as arrays
            // We group by the original _id of the ChatboatListing document.
            {
                $group: {
                    _id: "$_id",
                    is_city_select_all: { $first: "$is_city_select_all" },
                    createdAt: { $first: "$createdAt" }, // For sorting later
                    // Use $addToSet or $push to collect all unique names
                    // $addToSet ensures unique names, $push allows duplicates if needed
                    listing_names: {
                        $addToSet: { _id: "$listing_info_array._id", listing_unique_id: "$listing_info_array.listing_unique_id", name: "$listing_info_array.name" } // Collect all unique listing names
                    },
                    city_names: {
                        $addToSet: { _id: "$city_info_array._id", unique_id: "$city_info_array.unique_id", name: "$city_info_array.name" } // Collect all unique city names
                    }
                }
            },
            // Stage 7: Project the final desired fields
            {
                $project: {
                    _id: 1,
                    "listing_id": "$listing_names", // Now it's an array of names
                    "city_id": "$city_names", // Now it's an array of names
                    is_city_select_all: 1
                }
            },
            // Stage 8: Facet for total count and paginated data
            {
                $facet: {
                    totalCount: [{ $count: "count" }],
                    data: [{ $skip: skip }, { $limit: limit }, { $sort: { createdAt: -1 } }]
                }
            }
        ];
        const result = yield chatboat_schema_1.default.aggregate(pipeline);
        return {
            data: (_a = result[0]) === null || _a === void 0 ? void 0 : _a.data,
            totalUsers: ((_c = (_b = result[0]) === null || _b === void 0 ? void 0 : _b.totalCount[0]) === null || _c === void 0 ? void 0 : _c.count) || 0,
            totalPages: Math.ceil(((_e = (_d = result[0]) === null || _d === void 0 ? void 0 : _d.totalCount[0]) === null || _e === void 0 ? void 0 : _e.count) / limit) || 0,
            currentPage: page
        };
    }
    catch (error) {
        console.log(error);
        throw error;
    }
});
exports.chatboatListingModel = chatboatListingModel;
const chatBoatListingCityWise = (city_id, chat_boat_id) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        let listings;
        if (mongoose_1.default.isValidObjectId(chat_boat_id)) {
            const chatboatListing = yield chatboat_schema_1.default.findById(chat_boat_id).exec();
            if (!chatboatListing) {
                throw new Error("Chatboat listing not found.");
            }
            const excludedListingIds = chatboatListing.listing_id || [];
            const cityidNum = Number(city_id);
            const cityFilter = !isNaN(cityidNum)
                ? { city_id: { $in: [cityidNum] } }
                : {};
            listings = yield listing_schema_1.default.aggregate([
                { $match: Object.assign(Object.assign({}, cityFilter), { _id: { $nin: excludedListingIds } }) },
                {
                    $lookup: {
                        from: "cities",
                        localField: "city_id",
                        foreignField: "unique_id",
                        as: "city_info"
                    }
                },
                {
                    $unwind: {
                        path: "$city_info",
                        preserveNullAndEmptyArrays: true
                    }
                },
                {
                    $addFields: {
                        city_id: {
                            _id: "$city_info._id",
                            unique_id: "$city_info.unique_id",
                            name: "$city_info.name"
                        }
                    }
                },
                {
                    $project: {
                        city_info: 0
                    }
                },
                {
                    $group: {
                        _id: "$_id",
                        doc: { $first: "$$ROOT" }
                    }
                },
                {
                    $replaceRoot: {
                        newRoot: "$doc"
                    }
                }
            ]);
        }
        else {
            const cityidNum = Number(city_id);
            const cityFilter = !isNaN(cityidNum)
                ? { city_id: { $in: [cityidNum] } }
                : {};
            listings = yield listing_schema_1.default.aggregate([
                { $match: cityFilter },
                {
                    $lookup: {
                        from: "cities",
                        localField: "city_id",
                        foreignField: "unique_id",
                        as: "city_info"
                    }
                },
                {
                    $unwind: {
                        path: "$city_info",
                        preserveNullAndEmptyArrays: true
                    }
                },
                {
                    $addFields: {
                        city_id: {
                            _id: "$city_info._id",
                            unique_id: "$city_info.unique_id",
                            name: "$city_info.name"
                        }
                    }
                },
                {
                    $project: {
                        city_info: 0
                    }
                },
                {
                    $group: {
                        _id: "$_id",
                        doc: { $first: "$$ROOT" }
                    }
                },
                {
                    $replaceRoot: {
                        newRoot: "$doc"
                    }
                }
            ]);
        }
        return listings;
    }
    catch (error) {
        console.error("Error in chatBoatListingCityWise:", error);
        throw error;
    }
});
exports.chatBoatListingCityWise = chatBoatListingCityWise;
const storeChatboatListingModel = (body, callback) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const { city_id, listing_id = [], chat_boat_id = "" } = body;
        let is_all_city_selecteds = false;
        if (body.is_all_city_selected == "true") {
            is_all_city_selecteds = true;
        }
        else {
            is_all_city_selecteds = false;
        }
        // Validate city ID
        let numericCityId = null;
        if (city_id && !is_all_city_selecteds) {
            const parsedCityId = Number(city_id);
            if (isNaN(parsedCityId)) {
                return callback(new Error("Invalid city ID"), null);
            }
            numericCityId = parsedCityId;
        }
        // Validate listing IDs
        const listingObjectIds = Array.isArray(listing_id)
            ? listing_id.filter((id) => listing_schema_1.default.find({ listing_unique_id: id }))
            : [];
        let result;
        if (chat_boat_id && mongoose_1.default.isValidObjectId(chat_boat_id)) {
            // ✅ UPDATE existing record
            result = yield chatboat_schema_1.default.findByIdAndUpdate(chat_boat_id, {
                city_id: numericCityId,
                is_city_select_all: is_all_city_selecteds,
                listing_id: listingObjectIds
            }, { new: true });
        }
        else {
            // ✅ CREATE new record
            const chatboat = new chatboat_schema_1.default({
                city_id: numericCityId,
                is_city_select_all: is_all_city_selecteds,
                listing_id: listingObjectIds
            });
            result = yield chatboat.save();
        }
        callback(null, result);
    }
    catch (error) {
        callback(error, null);
    }
});
exports.storeChatboatListingModel = storeChatboatListingModel;
//# sourceMappingURL=chatboatListing.model.js.map